-- events


T_LOCKED = Localize ("Locked!");
T_HOW_TO_UNLOCK_TALISMAN = Localize ("You haven't discovered any Talismans yet.");


function OnLoad ()
	CacheSound ("music/map.ogg");
	CacheFX ("fxs/button-lock-breaks.lua");
end;

function OnEnter ()
	SwitchMusic ("music/map.ogg", 1, 2);
	SetProperty ("level_name:label.text", GetGameValue ("level_short_name"));
	local v = IsSetProfileVar ("GameCompleted");
	if (v) then
		SetProperty ("select_level:visible", 1);
	else
		SetProperty ("select_level:visible", 0);
	end;
	
	timer = 0;
	
end;

function OnLeave ()
	--RemoveProfileVar ("GotSomeTalisman");
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	levelname =  GetGameValue ("level_short_name");
	
	if (name == "Stats") then
		PushScreen ("Stats");
		return;
	end;
	
	if (name == "Play") then
	
		if(string.find(levelname, "-1")) then
			PushScreen ("Storyscreen");
			--SetProperty ("title:label.text", levelname);	
			return;
		end;
		InitGameLevel ();
		SwitchScreen ("Game");
		return;
	end;
	
	if (name == "MainMenu") then
		SaveGameState ("WorldMap");
		SwitchScreen ("MainMenu");
		return;
	end;
	
	if (name == "Shaman") then
	
		local pname = Azkend_GetPowerupID(0);
		local unlocked = GetGameValue ("powerup_unlocked_".. pname);
					
		--lev_num = GetGameValue ("level_number");
		if (not unlocked) then --lev_num <= 5) then
			SetProperty ("/InfoPopup/title:label.text", T_LOCKED);
			SetProperty ("/InfoPopup/text:label.text", T_HOW_TO_UNLOCK_TALISMAN);
			PushScreen ("InfoPopup");			
		else
			SwitchScreen("Shaman");
			return;
		end;
	end;

end;


function clamp (n, min, max)

	n = math.min (n, min);
	n = math.max (n, max);
	return n;
end;

function OnUpdate (tdelta)

	local pname = Azkend_GetPowerupID(0);
	local unlocked = GetGameValue ("powerup_unlocked_".. pname);
	
	if (IsTopScreen (GetProperty ("/:name"))) then
		timer = timer + tdelta;
	end;
	
	
	if (unlocked and not IsSetProfileVar ("GotSomeTalisman") and timer >= 0.7) then
		SetProfileVar ("GotSomeTalisman", "1");
		local x = GetProperty ("talismans_lock:static_position.x");
		local y = GetProperty ("talismans_lock:static_position.y");
		SpawnFX ("fxs/button-lock-breaks.lua", x, y, 0, 0);
	end;
	
	
	if (IsSetProfileVar ("GotSomeTalisman")) then
		SetProperty ("talismans_lock:visible", 0);
	else
		SetProperty ("talismans_lock:visible", 1);
	end;
		
	
	-- make the scroll pieces react to player progress on map
	local lev_num = GetGameValue ("level_number");
	local i = 11;
	while (i <= 10) do
		-- TODO: make this properly...
		local scale = 1;
		local alpha = clamp (1 - (lev_num/7 - i), 0, 1);
		if (i > lev_num/7 + 1) then
			alpha = 0.4;
			scale = 0.4;
		else
		end;
		SetProperty ("scroll" .. i .. ":alpha", alpha);
		SetProperty ("scroll" .. i .. ":scale", scale);
		i = i + 1;
	end;
end;

function OnDraw ()

end;
